#
# file: favs2html.rb
# language: Ruby 1.25 (http://www.netlab.co.jp/ruby)
#
# Converts the favorits-folder under Windows 95/98 into some HTML-pages.
# index.html is the start-page.
#
# implemented by Michael Neumann (neumann@s-direktnet.de)
# 24.05.1999
#




require 'dir_stuff.rb'
require 'char_conv.rb'

class Favs2Html
   attr "last_update", TRUE
   attr "email", TRUE
   attr "path", TRUE
   attr "showpath", TRUE
   attr "dstpath", TRUE
   attr "delim", TRUE
   attr "char_conv", TRUE

   def initialize
      a = Time.now
      @last_update = "#{a.day}.#{a.month}.#{a.year}"
      @email = "neumann@s-direktnet.de"
      @path =  "C:\\Windows\\Favoriten\\"
      @showpath = "Favoriten"
      @dstpath = ""
      @delim = " >> "
      @char_conv = FALSE
   end
   
   def convert
      @filenr = 0
      convert_favs(@path, @showpath)
   end

   def convert_favs(path, showpath)
      if @filenr == 0 then
         f = open("#{@dstpath}index.html","w+")
      else
         f = open("#{@dstpath}z#{@filenr}.html","w+")
      end
  
      printf(f, "%s", <<EOF)
         <html><head><title>#{conv(showpath)}</title></head><body>
         <h1>#{conv(showpath)}</h1><hr>
         <p><a href="javascript:history.back()"><img src="#{if @filenr==0 then "previous.gif" else "up.gif" end}"
         alt="#{if @filenr==0 then "back" else "directory up" end}"></a></p>
EOF

      @filenr += 1

      dirs  = list_subdirs(path).sort {|a,b| a.upcase <=> b.upcase}
      files = list_files(path).sort
    
      dirs.each {|i|
	 printf(f, "%s", "<img border=0 src=\"dir.gif\"> <a href=\"z#{@filenr}.html\">#{i}</a><br>\n")
         convert_favs(path+i+"\\", showpath+@delim+i)
      }

      if !dirs.empty? then printf(f, "%s", "<br>") end

      files.each {|i|
         IO.foreach(path+i) {|l|
            if l =~ /^URL=/ then
               url = conv(l[4..(l.size-1)])
               printf(f,"%s","<img src=\"file.gif\"> <a href=\"#{url}\">#{conv(i[0..(i.size-5)])}</a><br>")
            end

         }
      }

      printf(f, "%s", <<EOF)
         <br><hr><address>
         last update: #{conv(@last_update)}<br>
         email: <a href="mailto:#{conv(@email)}">#{conv(@email)}</a><br>
         </address></body></html>
EOF
      f.close
   end

   def conv(s) if @char_conv then conv_oem2ansi(s) else s end end

   private :convert_favs, :conv
end


#
# TEST-PROGRAM
#

if __FILE__ == $0
   a = Favs2Html.new

   # Languages
   a.path= "C:\\Windows\\Favoriten\\Informatik\\Programmiersprachen\\"
   a.dstpath= "lang\\"
   a.showpath= "Programmiersprachen"

   # only if you are in Germany ()
   a.char_conv = TRUE

   a.convert

   # Cryptology
   a.path= "C:\\Windows\\Favoriten\\Informatik\\Kryptologie\\"
   a.dstpath= "crypt\\"
   a.showpath= "Kryptologie"

   a.convert
end
