include FileTest

FILE, DIRECTORY, DIRECTORY_DOWN = 0..2


#
# depth:  -1 = recurse all
# yield:  path, name, type
#
def scan_dir(path, depth=-1)
   # remove \ at the end if present
   if path[-1].chr == "\\" then path = path[0,path.size-1] end

   dir = Dir.open(path)

   begin
      dir.each {|i|
	 if i !~ /^\.\.?$/
            if directory?(path+"\\"+i) then
               yield(path,i, DIRECTORY)
               scan_dir(path+"\\"+i,depth-1) {|a,b,c| yield(a,b,c)} unless depth==0
               yield(path,i, DIRECTORY_DOWN)
            elsif file?(path+"\\"+i)
               yield(path,i, FILE)
            end
         end
      }
   ensure
      dir.close
   end
end


# returns: a list with all files and directory of "path"
def listdir(path)
   a = []
   scan_dir(path, 0) {|path,name,type| a << name}
   return a
end


# returns a list with all subdirectorys of path
def list_subdirs(path)
   a = []
   scan_dir(path, 0) {|path,name,type| if type==DIRECTORY then a << name end}
   return a   
end

# returns a list with all files in path
def list_files(path)
   a = []
   scan_dir(path, 0) {|path,name,type| if type==FILE then a << name end}
   return a   
end


# returns true if name has the extension ext
def has_extension?(name, ext)
   return name.downcase =~ /(.)*[.]#{ext}$/
end




#
# TEST_PROGRAM
#

if __FILE__ == $0
   scan_dir("C:\\Windows\\Desktop\\",1) {|path,name,type|
      case type
      when DIRECTORY then
         print "DIR:  #{name}\n"
      when FILE  then
         print "FILE: #{name}\n"
      end
   }
   readline
end
       