#
# OEM  -> ANSI
# ANSI -> OEM
#

# ANSI-code is the index in the array, the resulting value is the corresponding OEM-code
ANSI_to_OEM = [
   0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
   22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
   42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
   62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
   82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101,
   102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
   118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 63, 63, 39, 159, 34, 46, 197,
   206, 94, 37, 83, 60, 79, 63, 90, 63, 63, 39, 39, 34, 34, 7, 45, 45, 126, 84, 115,
   62, 111, 63, 122, 89, 255, 173, 189, 156, 207, 190, 221, 245, 249, 184, 166, 174,
   170, 240, 169, 238, 248, 241, 253, 252, 239, 230, 244, 250, 247, 251, 167, 175,
   172, 171, 243, 168, 183, 181, 182, 199, 142, 143, 146, 128, 212, 144, 210, 211,
   222, 214, 215, 216, 209, 165, 227, 224, 226, 229, 153, 158, 157, 235, 233, 234,
   154, 237, 232, 225, 133, 160, 131, 198, 132, 134, 145, 135, 138, 130, 136, 137,
   141, 161, 140, 139, 208, 164, 149, 162, 147, 228, 148, 246, 155, 151, 163, 150,
   129, 236, 231, 152 ]


# OEM-code is the index in the array, the resulting value is the corresponding ANSI-code
OEM_to_ANSI = [
   0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 164, 16, 17, 18, 19, 182, 167,
   22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
   42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
   62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
   82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101,
   102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
   118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 199, 252, 233, 226, 228, 224,
   229, 231, 234, 235, 232, 239, 238, 236, 196, 197, 201, 230, 198, 244, 246, 242,
   251, 249, 255, 214, 220, 248, 163, 216, 215, 131, 225, 237, 243, 250, 241, 209,
   170, 186, 191, 174, 172, 189, 188, 161, 171, 187, 166, 166, 166, 166, 166, 193,
   194, 192, 169, 166, 166, 43, 43, 162, 165, 43, 43, 45, 45, 43, 45, 43, 227, 195,
   43, 43, 45, 45, 166, 45, 43, 164, 240, 208, 202, 203, 200, 105, 205, 206, 207, 43,
   43, 166, 95, 166, 204, 175, 211, 223, 212, 210, 245, 213, 181, 254, 222, 218, 219,
   217, 253, 221, 175, 180, 173, 177, 61, 190, 182, 167, 247, 184, 176, 168, 183,
   185, 179, 178, 166, 160 ]

# returns str as ansi
def conv_oem2ansi(str)
   ansi_str = ""
   str.each_byte {|i| ansi_str += OEM_to_ANSI[i].chr }
   return ansi_str
end

# returns str as oem
def conv_ansi2oem(str)
   oem_str = ""
   str.each_byte {|i| oem_str += ANSI_to_OEM[i].chr }
   return oem_str
end
