/*
 *  (c) 1995 Microsoft Corporation. All rights reserved.
 *  Developed by ActiveWare Internet Corp., http://www.ActiveWare.com
 *
 *  Other modifications Copyright (c) 1997, 1998 by Gurusamy Sarathy
 *  <gsar@umich.edu> and Jan Dubois <jan.dubois@ibm.net>
 *
 *  You may distribute under the terms of either the GNU General Public
 *  License or the Artistic License, as specified in the README file
 *  of the Perl distribution.
 *
 */

/*
  $Date: 2000-05-25 19:22:16+09 $
  modified for win32ole (ruby) by M.Suketa <CQN02273@nifty.ne.jp>
 */

#include "ruby.h"
#include "st.h"
#include <windows.h>
#include <ocidl.h>
#include <ole2.h>

#if 0
#define DOUT fprintf(stdout,"[%d]\n",__LINE__)
#define DOUTS(x) fprintf(stdout,"[%d]:" #x "=%s\n",__LINE__,x)
#define DOUTMSG(x) fprintf(stdout, "[%d]:" #x "\n",__LINE__)
#define DOUTI(x) fprintf(stdout, "[%d]:" #x "=%d\n",__LINE__,x)
#define DOUTD(x) fprintf(stdout, "[%d]:" #x "=%f\n",__LINE__,x)
#endif

#define WIN32OLE_VERSION "0.1.2"

typedef struct {
    struct IEventSinkVtbl * lpVtbl;
} IEventSink, *PEVENTSINK;

typedef struct IEventSinkVtbl IEventSinkVtbl;

struct IEventSinkVtbl {
    STDMETHOD(QueryInterface)(
        PEVENTSINK,
        REFIID,
        LPVOID *);
    STDMETHOD_(ULONG, AddRef)(PEVENTSINK);
    STDMETHOD_(ULONG, Release)(PEVENTSINK);

    STDMETHOD(GetTypeInfoCount)(
        PEVENTSINK,
        UINT *);
    STDMETHOD(GetTypeInfo)(
        PEVENTSINK,
        UINT,
        LCID,
        ITypeInfo **);
    STDMETHOD(GetIDsOfNames)(
        PEVENTSINK,
        REFIID,
        OLECHAR **,
        UINT,
        LCID,
        DISPID *);
    STDMETHOD(Invoke)(
        PEVENTSINK,
        DISPID,
        REFIID,
        LCID,
        WORD,
        DISPPARAMS *,
        VARIANT *,
        EXCEPINFO *,
        UINT *);
};

typedef struct tagIEVENTSINKOBJ {
    IEventSinkVtbl *lpVtbl;
    DWORD m_cRef;
    IID m_iid;
    int m_event_id;
    DWORD m_dwCookie;
    IConnectionPoint *pConnectionPoint;
    ITypeInfo *pTypeInfo;
}IEVENTSINKOBJ, *PIEVENTSINKOBJ;

VALUE cWIN32OLE;
VALUE cWIN32OLE_EVENT;
static VALUE ary_ole_event;
static ID id_events;
static BOOL gOLEInitialized = Qfalse;

struct oledata {
    IDispatch *pDispatch;
};

struct oleeventdata {
    IEVENTSINKOBJ *pEvent;
};

struct oleparam {
    DISPPARAMS dp;
    OLECHAR** pNamedArgs;
};

static void
time2d(hh, mm, ss, pv)
    int hh, mm, ss;
    double *pv;
{
    *pv =  (hh * 60.0 * 60.0 + mm * 60.0 + ss) / 86400.0;
}

static void
d2time(v, hh, mm, ss)
    double v;
    int *hh, *mm, *ss;
{
    double d_hh, d_mm, d_ss;
    int    i_hh, i_mm, i_ss;

    double d = v * 86400.0;

    d_hh = d / 3600.0;
    i_hh = (int)d_hh;

    d = d - i_hh * 3600.0;

    d_mm = d / 60.0;
    i_mm = (int)d_mm;

    d = d - i_mm * 60.0;

    d_ss = d * 10.0 + 5;
    
    i_ss = (int)d_ss / 10;

    if(i_ss == 60) {
        i_mm += 1;
        i_ss = 0;
    }

    if (i_mm == 60) {
        i_hh += 1;
        i_mm = 0;
    }
    if (i_hh == 24) {
        i_hh = 0;
    }
    
    *hh = i_hh;
    *mm = i_mm;
    *ss = i_ss;
}

static void
civil2jd(y, m, d, jd)
    int y, m, d;
    long *jd;
{
    long a, b;
    if (m <= 2) {
        y -= 1;
        m += 12;
    }
    a = (long)(y / 100.0);
    b = 2 - a + (long)(a / 4.0);
    *jd = (long)(365.25 * (double)(y + 4716))
         + (long)(30.6001 * (m + 1))
	 + d + b - 1524;
}

static void
jd2civil(day, yy, mm, dd)
    long day;
    int *yy, *mm, *dd;
{
    long x, a, b, c, d, e;
    x = (long)(((double)day - 1867216.25) / 36524.25);
    a = day + 1 + x - (long)(x / 4.0);
    b = a + 1524;
    c = (long)(((double)b -122.1) /365.25);
    d = (long)(365.25 * c);
    e = (long)((double)(b - d) / 30.6001);
    *dd = b - d - (long)(30.6001 * e);
    if (e <= 13) {
        *mm = e - 1;
        *yy = c - 4716;
    }
    else {
        *mm = e - 13;
        *yy = c - 4715;
    }
}

static void
double2time(v, y, m, d, hh, mm, ss)
    double v;
    int *y, *m, *d, *hh, *mm, *ss;
{
    long day;
    double t;

    day = (long)v;
    t = v - day;
    jd2civil(2415019 + day, y, m, d);

    d2time(t, hh, mm, ss);
}

static double
time_object2date(tmobj)
    VALUE tmobj;
{
    long y, m, d, hh, mm, ss;
    long day;
    double t;
    y = FIX2INT(rb_funcall(tmobj, rb_intern("year"), 0));
    m = FIX2INT(rb_funcall(tmobj, rb_intern("month"), 0));
    d = FIX2INT(rb_funcall(tmobj, rb_intern("mday"), 0));
    hh = FIX2INT(rb_funcall(tmobj, rb_intern("hour"), 0));
    mm = FIX2INT(rb_funcall(tmobj, rb_intern("min"), 0));
    ss = FIX2INT(rb_funcall(tmobj, rb_intern("sec"), 0));
    civil2jd(y, m, d, &day);
    time2d(hh, mm, ss, &t);
    return t + day - 2415019;
}

static VALUE
date2time_str(date)
    double date;
{
    int y, m, d, hh, mm, ss;
    char szTime[20];
    double2time(date, &y, &m, &d, &hh, &mm, &ss);
    sprintf(szTime,
            "%4.4d/%02.2d/%02.2d %02.2d:%02.2d:%02.2d",
            y, m, d, hh, mm, ss);
    return rb_str_new2(szTime);
}

static void ole_val2variant();
static void ole_raise();

void
ole_uninitialize()
{

    OleUninitialize();
    gOLEInitialized = Qfalse;
}

static void
ole_initialize() 
{
    HRESULT hr;
    int rc;
    
    if(gOLEInitialized == Qfalse) {
        hr = OleInitialize(NULL);
        if(FAILED(hr)) {
            ole_raise(hr, rb_eRuntimeError, "Fail : OLE initialize");
        }
        gOLEInitialized = Qtrue;
        rc = atexit((void (*)(void))ole_uninitialize);
    }
}

static void
ole_msg_loop() {
    MSG msg;
    while(PeekMessage(&msg,NULL,0,0,PM_REMOVE)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
}

static void
ole_free(pole)
    struct oledata *pole;
{
    ULONG n;
    if(gOLEInitialized == Qtrue) {
        if(pole->pDispatch) {
            n = pole->pDispatch->lpVtbl->Release(pole->pDispatch);
            pole->pDispatch = 0;
        }
    }
    ole_msg_loop();
    CoFreeUnusedLibraries();
}

static LPWSTR
ole_mb2wc(pm, len)
    char *pm;
    int  len;
{
    int size;
    LPWSTR pw;
    size = MultiByteToWideChar(CP_ACP, 0, pm, len, NULL, 0);
    pw = SysAllocStringLen(NULL, size);
    MultiByteToWideChar(CP_ACP, 0, pm, len, pw, size);
    return pw;
}

static char *
ole_wc2mb(pw)
    LPWSTR pw;
{
    int size;
    LPSTR pm;
    size = WideCharToMultiByte(CP_ACP, 0, pw, -1, NULL, 0, NULL, NULL);
    pm = ALLOC_N(char, size);    
    WideCharToMultiByte(CP_ACP, 0, pw, -1, pm, size, NULL, NULL);
    return pm;
} 

static VALUE
ole_hresult2msg(hr)
    HRESULT hr;
{
    VALUE msg = Qnil;
    char *p_msg;
    DWORD dwCount;

    dwCount = FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
                            FORMAT_MESSAGE_FROM_SYSTEM |
                            FORMAT_MESSAGE_IGNORE_INSERTS,
                            NULL, hr, LOCALE_SYSTEM_DEFAULT,
                            (LPTSTR)&p_msg, 0, NULL);
    if (dwCount > 0) {
	/* remove dots and CRs/LFs */
	while (dwCount > 0 &&
               (p_msg[dwCount-1] < ' ' || p_msg[dwCount-1] == '.')) {
	    p_msg[--dwCount] = '\0';
        }
        if (p_msg[0] != '\0') {
            msg = rb_str_new2(p_msg);
        }
    }
    return msg;
}

static VALUE
ole_excepinfo2msg(pExInfo)
    EXCEPINFO *pExInfo;
{
    char error_code[40];
    char *pSource = NULL;
    char *pDescription = NULL;
    VALUE error_msg;
    if(pExInfo->pfnDeferredFillIn != NULL) {
        (*pExInfo->pfnDeferredFillIn)(pExInfo);
    }
    if (pExInfo->bstrSource != NULL) {
        pSource = ole_wc2mb(pExInfo->bstrSource);
    }
    if (pExInfo->bstrDescription != NULL) {
        pDescription = ole_wc2mb(pExInfo->bstrDescription);
    }
    if(pExInfo->wCode == 0) {
        sprintf(error_code, "\n    OLE rb_compile_error:%lX in ", pExInfo->scode);
    }
    else{
        sprintf(error_code, "\n    OLE rb_compile_error:%u in ", pExInfo->wCode);
    }
    error_msg = rb_str_new2(error_code);
    if(pSource != NULL) {
        rb_str_cat(error_msg, pSource, strlen(pSource));
    }
    else {
        rb_str_cat(error_msg, "<Unknown>", 9);
    }
    rb_str_cat(error_msg, "\n    ", 5);
    if(pDescription != NULL) {
        rb_str_cat(error_msg, pDescription, strlen(pDescription));
    }
    else {
        rb_str_cat(error_msg, "<No Description>", 16);
    }
    if(pSource) free(pSource);
    if(pDescription) free(pDescription);
    SysFreeString(pExInfo->bstrDescription);
    SysFreeString(pExInfo->bstrSource);
    SysFreeString(pExInfo->bstrHelpFile);
    return error_msg;
}

static void
ole_raise(hr, ecs, p_msg)
    HRESULT hr;
    VALUE ecs;
    const char *p_msg;
{
    VALUE err_msg;
    err_msg = ole_hresult2msg(hr);
    if(err_msg != Qnil) {
        rb_raise(ecs, "%s\n%s", p_msg, RSTRING(err_msg)->ptr);
    }
    else {
        rb_raise(ecs, "%s", p_msg);
    }
}

static VALUE
ole_ary_m_entry(val, pid)
    VALUE val;
    long *pid;
{
    VALUE obj = Qnil;
    int i = 0;
    obj = val;
    while(TYPE(obj) == T_ARRAY) {
        obj = rb_ary_entry(obj, pid[i]);
        i++;
    }
    return obj;
}

static void
ole_set_safe_array(n, psa, pid, pub, val, dim)
    long n;
    SAFEARRAY *psa;
    long *pid;
    long *pub;
    VALUE val;
    long dim;
{
    VALUE val1;
    VARIANT var;
    VariantInit(&var);
    if(n < 0) return;
    if(n == dim) {
        val1 = ole_ary_m_entry(val, pid);
        ole_val2variant(val1, &var);
        SafeArrayPutElement(psa, pid, &var);
    }
    pid[n] += 1;
    if (pid[n] < pub[n]) {
        ole_set_safe_array(dim, psa, pid, pub, val, dim);
    }
    else {
        pid[n] = 0;
        ole_set_safe_array(n-1, psa, pid, pub, val, dim);
    }
}

static void
ole_val2variant(val, var)
    VALUE val;
    VARIANT *var;
{
    struct oledata *pole;
    if(rb_obj_is_kind_of(val, cWIN32OLE)) {
        Data_Get_Struct(val, struct oledata, pole);
        pole->pDispatch->lpVtbl->AddRef(pole->pDispatch); 
        V_VT(var) = VT_DISPATCH;
        V_DISPATCH(var) = pole->pDispatch;
        return;
    }
    if (rb_obj_is_kind_of(val, rb_cTime)) {
        V_VT(var) = VT_DATE;
        V_DATE(var) = time_object2date(val);
        return;
    }
    switch (TYPE(val)) {
    case T_ARRAY:
    {
        VALUE val1;
        long dim = 0;
        int  i = 0;

        HRESULT hr;
        SAFEARRAYBOUND *psab;
        SAFEARRAY *psa;
        long      *pub, *pid;

        val1 = val;
        while(TYPE(val1) == T_ARRAY) {
            val1 = rb_ary_entry(val1, 0);
            dim += 1;
        }
        psab = ALLOC_N(SAFEARRAYBOUND, dim);
        pub  = ALLOC_N(long, dim);
        pid  = ALLOC_N(long, dim);

        if(!psab || !pub || !pid) {
            if(pub) free(pub);
            if(psab) free(psab);
            if(pid) free(pid);
            rb_raise(rb_eRuntimeError, "memory allocate error");
        }
        val1 = val;
        i = 0;
        while(TYPE(val1) == T_ARRAY) {
            psab[i].cElements = RARRAY(val1)->len;
            psab[i].lLbound = 0;
            pub[i] = psab[i].cElements;
            pid[i] = 0;
            i ++;
            val1 = rb_ary_entry(val1, 0);
        }
        /* Create and fill VARIANT array */
        psa = SafeArrayCreate(VT_VARIANT, dim, psab);
        if (psa == NULL)
            hr = E_OUTOFMEMORY;
        else
            hr = SafeArrayLock(psa);
        if (SUCCEEDED(hr)) {
            ole_set_safe_array(dim-1, psa, pid, pub, val, dim-1);
            hr = SafeArrayUnlock(psa);
        }
        if(pub) free(pub);
        if(psab) free(psab);
        if(pid) free(pid);

        if (SUCCEEDED(hr)) {
            V_VT(var) = VT_VARIANT | VT_ARRAY;
            V_ARRAY(var) = psa;
        }
        else if (psa != NULL)
            SafeArrayDestroy(psa);
        break;
    }
    case T_STRING:
        V_VT(var) = VT_BSTR;
        V_BSTR(var) = ole_mb2wc(RSTRING(val)->ptr, -1);
        break;
    case T_FIXNUM:
        V_VT(var) = VT_I4;
        V_I4(var) = NUM2INT(val);
        break;
    case T_FLOAT:
        V_VT(var) = VT_R8;
        V_R8(var) = NUM2DBL(val);
        break;
    case T_TRUE:
        V_VT(var) = VT_BOOL;
        V_BOOL(var) = VARIANT_TRUE;
        break;
    case T_FALSE:
        V_VT(var) = VT_BOOL;
        V_BOOL(var) = VARIANT_FALSE;
        break;
    case T_NIL:
        V_VT(var) = VT_ERROR;
        V_ERROR(var) = DISP_E_PARAMNOTFOUND;
        break;
    default:
        rb_raise(rb_eTypeError, "not valid value");
        break;
    }
}

static VALUE
ole_variant2val(pvar)
    VARIANT *pvar;
{
    VALUE obj = Qnil;
    HRESULT hr;

    if(V_ISARRAY(pvar)) {
        SAFEARRAY *psa = V_ISBYREF(pvar) ? *V_ARRAYREF(pvar) : V_ARRAY(pvar);
        long i;
        long *pID, *pLB, *pUB;
        VARIANT variant;
        VALUE val;
        VALUE val2;

        int dim = SafeArrayGetDim(psa);
        VariantInit(&variant);
        V_VT(&variant) = (V_VT(pvar) & ~VT_ARRAY) | VT_BYREF;

        pID = ALLOC_N(long, dim);
        pLB = ALLOC_N(long, dim);
        pUB = ALLOC_N(long, dim);

        if(!pID || !pLB || !pUB) {
            if(pID) free(pID);
            if(pLB) free(pLB);
            if(pUB) free(pUB);
            rb_raise(rb_eRuntimeError, "memory allocate error");
        }

        obj = rb_ary_new();

        for(i = 0; i < dim; ++i) {
            SafeArrayGetLBound(psa, i+1, &pLB[i]);
            SafeArrayGetLBound(psa, i+1, &pID[i]);
            SafeArrayGetUBound(psa, i+1, &pUB[i]);
        }

        hr = SafeArrayLock(psa);
        if (SUCCEEDED(hr)) {
            val2 = rb_ary_new();
            while (i >= 0) {
                hr = SafeArrayPtrOfIndex(psa, pID, &V_BYREF(&variant));
                if (FAILED(hr))
                    break;

                val = ole_variant2val(&variant);
                rb_ary_push(val2, val);
                VariantClear(&variant);
                for (i = dim-1 ; i >= 0 ; --i) {
                    if (++pID[i] <= pUB[i])
                        break;

                    pID[i] = pLB[i];
                    if (i > 0) {
                        rb_ary_push(obj, val2);
                        val2 = rb_ary_new();
                    }
                }
            }
            SafeArrayUnlock(psa);
        }
        if(pID) free(pID);
        if(pLB) free(pLB);
        if(pUB) free(pUB);
        return obj;
    }

    while ( V_VT(pvar) == (VT_BYREF | VT_VARIANT) )
        pvar = V_VARIANTREF(pvar);
        
    switch(V_VT(pvar) & ~VT_BYREF){
    case VT_EMPTY:
        break;
    case VT_NULL:
        break;
    case VT_UI1:
        if(V_ISBYREF(pvar)) 
            obj = INT2NUM((long)*V_UI1REF(pvar));
        else 
            obj = INT2NUM((long)V_UI1(pvar));
        break;

    case VT_I2:
        if(V_ISBYREF(pvar))
            obj = INT2NUM((long)*V_I2REF(pvar));
        else 
            obj = INT2NUM((long)V_I2(pvar));
        break;

    case VT_I4:
        if(V_ISBYREF(pvar))
            obj = INT2NUM((long)*V_I4REF(pvar));
        else 
            obj = INT2NUM((long)V_I4(pvar));
        break;

    case VT_R4:
        if(V_ISBYREF(pvar))
            obj = rb_float_new(*V_R4REF(pvar));
        else
            obj = rb_float_new(V_R4(pvar));
        break;

    case VT_R8:
        if(V_ISBYREF(pvar))
            obj = rb_float_new(*V_R8REF(pvar));
        else
            obj = rb_float_new(V_R8(pvar));
        break;

    case VT_BSTR:
    {
        char *p;
        if(V_ISBYREF(pvar))
            p = ole_wc2mb(*V_BSTRREF(pvar));
        else
            p = ole_wc2mb(V_BSTR(pvar));
        obj = rb_str_new2(p);
        if(p) free(p);
        break;
    }

    case VT_ERROR:
        if(V_ISBYREF(pvar))
            obj = INT2NUM(*V_ERRORREF(pvar));
        else
            obj = INT2NUM(V_ERROR(pvar));
        break;

    case VT_BOOL:
        if (V_ISBYREF(pvar))
            obj = (*V_BOOLREF(pvar) ? Qtrue : Qfalse);
        else
            obj = (V_BOOL(pvar) ? Qtrue : Qfalse);
        break;

    case VT_DISPATCH:
    {
        IDispatch *pDispatch;
        struct oledata *pole;

        if (V_ISBYREF(pvar))
            pDispatch = *V_DISPATCHREF(pvar);
        else
            pDispatch = V_DISPATCH(pvar);

        if (pDispatch != NULL ) {
            pDispatch->lpVtbl->AddRef(pDispatch);
            obj = Data_Make_Struct(cWIN32OLE, struct oledata,
                                   0, ole_free,pole);
            pole->pDispatch = pDispatch;
        }
        break;
    }

    case VT_UNKNOWN:
    {

        /* get IDispatch interface from IUnknown interface */
        IUnknown *punk;
        IDispatch *pDispatch;
        struct oledata *pole;
        HRESULT hr;

        if (V_ISBYREF(pvar))
            punk = *V_UNKNOWNREF(pvar);
        else
            punk = V_UNKNOWN(pvar);

        if(punk != NULL) {
           hr = punk->lpVtbl->QueryInterface(punk, &IID_IDispatch,
                                             (void **)&pDispatch);
           if(SUCCEEDED(hr)) {
               obj = Data_Make_Struct(cWIN32OLE, struct oledata,
                                      0, ole_free,pole);
               pole->pDispatch = pDispatch;
           }
        }
        break;
    }

    case VT_DATE:
    {
        DATE date;
        if(V_ISBYREF(pvar))
            date = *V_DATEREF(pvar);
        else
            date = V_DATE(pvar);

        obj =  date2time_str(date);
        break;
    }
    case VT_CY:
    default:
        {
        HRESULT hr;
        VARIANT variant;
        VariantInit(&variant);
        hr = VariantChangeTypeEx(&variant, pvar, 
                                  LOCALE_SYSTEM_DEFAULT, 0, VT_BSTR);
        if (SUCCEEDED(hr) && V_VT(&variant) == VT_BSTR) {
            char *p = ole_wc2mb(V_BSTR(&variant));
            obj = rb_str_new2(p);
            if(p) free(p);
        }
        VariantClear(&variant);
        break;
        }
    }
    return obj;
}

static void
ole_const_load(pTypeLib, klass, self)
    ITypeLib *pTypeLib;
    VALUE klass;
    VALUE self;
{
    unsigned int count;
    unsigned int index;
    int iVar;
    ITypeInfo *pTypeInfo;
    TYPEATTR  *pTypeAttr;
    VARDESC   *pVarDesc;
    HRESULT hr;
    unsigned int len;
    BSTR bstr;
    char *pName = NULL;
    VALUE val;
    VALUE constant;
    ID id;
    constant = rb_hash_new();
    count = pTypeLib->lpVtbl->GetTypeInfoCount(pTypeLib);
    for (index = 0; index < count; index++) {
        hr = pTypeLib->lpVtbl->GetTypeInfo(pTypeLib, index, &pTypeInfo);
        if (FAILED(hr))
            continue;
        hr = pTypeInfo->lpVtbl->GetTypeAttr(pTypeInfo, &pTypeAttr);
        if(FAILED(hr)) {
            pTypeInfo->lpVtbl->Release(pTypeInfo);
            continue;
        }
        for(iVar = 0; iVar < pTypeAttr->cVars; iVar++) {
            hr = pTypeInfo->lpVtbl->GetVarDesc(pTypeInfo, iVar, &pVarDesc);
            if(FAILED(hr))
                continue;
            if(pVarDesc->varkind == VAR_CONST &&
               !(pVarDesc->wVarFlags & (VARFLAG_FHIDDEN |
                                        VARFLAG_FRESTRICTED |
                                        VARFLAG_FNONBROWSABLE))) {
                hr = pTypeInfo->lpVtbl->GetNames(pTypeInfo, pVarDesc->memid, &bstr,
                                                 1, &len);
                if(FAILED(hr) || len == 0 || !bstr)
                    continue;
                pName = ole_wc2mb(bstr);
                val = ole_variant2val(V_UNION(pVarDesc, lpvarValue));
                *pName = toupper(*pName);
                id = rb_intern(pName);
                if (rb_is_const_id(id)) {
                    rb_define_const(klass, pName, val);
                }
                else {
                    rb_hash_aset(constant, rb_str_new2(pName), val);
                }
                SysFreeString(bstr);
                if(pName) {
                    free(pName);
                    pName = NULL;
                }
            }
            pTypeInfo->lpVtbl->ReleaseVarDesc(pTypeInfo, pVarDesc);
        }
        pTypeInfo->lpVtbl->ReleaseTypeAttr(pTypeInfo, pTypeAttr);
        pTypeInfo->lpVtbl->Release(pTypeInfo);
    }
    rb_define_const(klass, "CONSTANTS", constant);
}

static VALUE
fole_s_new(self, svr_name)
    VALUE self;
    VALUE svr_name;
{
    VALUE err_msg;
    HRESULT hr;
    CLSID   clsid;
    OLECHAR *pBuf;
    struct oledata *pole;
    IDispatch *pDispatch;
    VALUE obj;

    /* initialize to use OLE */
    ole_initialize();

    /* get CLSID from OLE server name */
    pBuf  = ole_mb2wc(RSTRING(svr_name)->ptr, -1);
    hr = CLSIDFromProgID(pBuf, &clsid);
    SysFreeString(pBuf);
    if(FAILED(hr)) {
        err_msg = rb_str_new2("Unknown OLE server : ");
        rb_str_concat(err_msg, svr_name);
        ole_raise(hr, rb_eRuntimeError, RSTRING(err_msg)->ptr);
    }

    /* get IDispatch interface */
    hr = CoCreateInstance(&clsid, NULL, CLSCTX_INPROC_SERVER | CLSCTX_LOCAL_SERVER,
                          &IID_IDispatch, (void**)&pDispatch);
    if(FAILED(hr)) {
        err_msg = rb_str_new2("Fail to create WIN32OLE object from ");
        rb_str_concat(err_msg, svr_name);
        ole_raise(hr, rb_eRuntimeError, RSTRING(err_msg)->ptr);
    }

    /* create WIN32OLE object */
    obj = Data_Make_Struct(self,struct oledata,0,ole_free,pole);
    pole->pDispatch = pDispatch;
    rb_obj_call_init(obj, 0, 0);
    return obj;
}

static VALUE
fole_s_connect(self, svr_name)
    VALUE self;
    VALUE svr_name;
{
    HRESULT hr;
    CLSID   clsid;
    OLECHAR *pBuf;
    struct oledata *pole;
    IDispatch *pDispatch;
    IUnknown *pUnknown;
    VALUE obj;
    VALUE err_msg;

    /* initialize to use OLE */
    ole_initialize();

    /* get CLSID from OLE server name */
    pBuf  = ole_mb2wc(RSTRING(svr_name)->ptr, -1);
    hr = CLSIDFromProgID(pBuf, &clsid);
    SysFreeString(pBuf);
    if(FAILED(hr)) {
        err_msg = rb_str_new2("Unknown OLE server : ");
        rb_str_concat(err_msg, svr_name);
        ole_raise(hr, rb_eRuntimeError, RSTRING(err_msg)->ptr);
    }

    hr = GetActiveObject(&clsid, 0, &pUnknown);
    if (FAILED(hr)) {
        err_msg = rb_str_new2("Not Running OLE server : ");
        rb_str_concat(err_msg, svr_name);
        ole_raise(hr, rb_eRuntimeError, RSTRING(err_msg)->ptr);
    }
    hr = pUnknown->lpVtbl->QueryInterface(pUnknown, &IID_IDispatch,
                                             (void **)&pDispatch);
    if(FAILED(hr)) {
        err_msg = rb_str_new2("Fail to create WIN32OLE server : ");
        rb_str_concat(err_msg, svr_name);
        ole_raise(hr, rb_eRuntimeError, RSTRING(err_msg)->ptr);
    }

    /* create WIN32OLE object */
    obj = Data_Make_Struct(self,struct oledata,0,ole_free,pole);
    pole->pDispatch = pDispatch;
    rb_obj_call_init(obj, 0, 0);
    return obj;
}

static VALUE
fole_s_const_load(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE ole;
    VALUE klass;
    struct oledata *pole;
    ITypeInfo *pTypeInfo;
    ITypeLib *pTypeLib;
    unsigned int index;
    HRESULT hr;
    LCID    lcid = LOCALE_SYSTEM_DEFAULT;
    
    rb_scan_args(argc, argv, "11", &ole, &klass);
    if (TYPE(klass) != T_CLASS &&
        TYPE(klass) != T_MODULE &&
        TYPE(klass) != T_NIL) {
        rb_raise(rb_eTypeError, "2nd paramator must be Class or Module.");
    }
    if (rb_obj_is_kind_of(ole, cWIN32OLE)) {
        Data_Get_Struct(ole, struct oledata, pole);
        hr = pole->pDispatch->lpVtbl->GetTypeInfo(pole->pDispatch,
                                                  0, lcid, &pTypeInfo);
        if(FAILED(hr)) {
            ole_raise(hr, rb_eRuntimeError, "fail to GetTypeInfo");
        }
        hr = pTypeInfo->lpVtbl->GetContainingTypeLib(pTypeInfo, &pTypeLib, &index);
        if(FAILED(hr)) {
            pTypeInfo->lpVtbl->Release(pTypeInfo);
            ole_raise(hr, rb_eRuntimeError, "fail to GetContainingTypeLib");
        }
        pTypeInfo->lpVtbl->Release(pTypeInfo);
        if(TYPE(klass) != T_NIL) {
            ole_const_load(pTypeLib, klass, self);
        }
        else {
            ole_const_load(pTypeLib, cWIN32OLE, self);
        }
        pTypeLib->lpVtbl->Release(pTypeLib);
    }
    else {
        rb_raise(rb_eTypeError, "1st paramator must be WIN32OLE instance");
    }
    return Qnil;
}

static VALUE
hash2named_arg(pair, pOp)
    VALUE pair;
    struct oleparam* pOp;
{
    unsigned int index, i;
    VALUE key, value;
    index = pOp->dp.cNamedArgs;

    /*-------------------------------------
      the data-type of key must be String
    ---------------------------------------*/
    key = rb_ary_entry(pair, 0);
    if(TYPE(key) != T_STRING) {
        /* clear name of dispatch parameters */
        for(i = 1; i < index + 1; i++) {
            SysFreeString(pOp->pNamedArgs[i]);
        }
        /* clear dispatch parameters */
        for(i = 0; i < index; i++ ) {
            VariantClear(&(pOp->dp.rgvarg[i]));
        }
        /* raise an exception */
        Check_Type(key, T_STRING);
    }

    /* pNamedArgs[0] is <method name>, so "index + 1" */
    pOp->pNamedArgs[index + 1] = ole_mb2wc(RSTRING(key)->ptr, -1);

    value = rb_ary_entry(pair, 1);
    VariantInit(&(pOp->dp.rgvarg[index]));
    ole_val2variant(value, &(pOp->dp.rgvarg[index]));

    pOp->dp.cNamedArgs += 1;
    return Qnil;
}

static VALUE
ole_invoke(argc, argv, self, wFlags)
    int argc;
    VALUE *argv;
    VALUE self;
    USHORT wFlags;
{
    LCID    lcid = LOCALE_SYSTEM_DEFAULT;
    struct oledata *pole;
    HRESULT hr;
    VALUE cmd;
    VALUE paramS;
    VALUE param;
    VALUE obj;
    VALUE error_msg;
    VALUE err_msg;

    DISPID* pDispID;
    EXCEPINFO excepinfo;
    VARIANT result;
    unsigned int argErr;
    unsigned int i;
    unsigned int cNamedArgs;
    struct oleparam op;
    memset(&excepinfo, 0, sizeof(EXCEPINFO));

    VariantInit(&result);

    op.dp.rgvarg = NULL;
    op.dp.rgdispidNamedArgs = NULL;
    op.dp.cNamedArgs = 0;
    op.dp.cArgs = 0;

    rb_scan_args(argc, argv, "1*", &cmd, &paramS);
    Data_Get_Struct(self, struct oledata, pole);

    /* pick up last argument of method */
    param = rb_ary_entry(paramS, argc-2);

    op.dp.cNamedArgs = 0;

    /* if last arg is hash object */
    if(TYPE(param) == T_HASH) {
        /*------------------------------------------ 
          hash object ==> named dispatch parameters 
        --------------------------------------------*/
        cNamedArgs = NUM2INT(rb_funcall(param, rb_intern("length"), 0));
        op.dp.cArgs = cNamedArgs + argc - 2;
        op.pNamedArgs = ALLOCA_N(OLECHAR*, cNamedArgs + 1);
        op.dp.rgvarg = ALLOCA_N(VARIANTARG, op.dp.cArgs);
        rb_iterate(rb_each, param, hash2named_arg, (VALUE)&op);
    }
    else {
        cNamedArgs = 0;
        op.dp.cArgs = argc - 1;
        op.pNamedArgs = ALLOCA_N(OLECHAR*, cNamedArgs + 1);
        if (op.dp.cArgs > 0) {
            op.dp.rgvarg  = ALLOCA_N(VARIANTARG, op.dp.cArgs);
        }
    }

    /*-----------------------------------------------------------
      get IDs from method name (or property name) and named args 
    -------------------------------------------------------------*/
    pDispID = ALLOCA_N(DISPID, cNamedArgs + 1);
    op.pNamedArgs[0] = ole_mb2wc(RSTRING(cmd)->ptr, -1);
    hr = pole->pDispatch->lpVtbl->GetIDsOfNames(pole->pDispatch,
                                                &IID_NULL,
                                                op.pNamedArgs,
                                                op.dp.cNamedArgs + 1,
                                                lcid, pDispID);
    for(i = 0; i < op.dp.cNamedArgs + 1; i++) {
        SysFreeString(op.pNamedArgs[i]);
    }
    if(FAILED(hr)) {
        /* clear dispatch parameters */
        for(i = 0; i < op.dp.cArgs; i++ ) {
            VariantClear(&op.dp.rgvarg[i]);
        }
        err_msg = rb_str_new2("Unknown property or method : ");
        rb_str_concat(err_msg, cmd);
        ole_raise(hr, rb_eRuntimeError, RSTRING(err_msg)->ptr);
    }

    /*--------------------------------------
      non hash args ==> dispatch parameters 
     ----------------------------------------*/
    if(op.dp.cArgs > cNamedArgs) {
        for(i = cNamedArgs; i < op.dp.cArgs; i++) {
            int n = op.dp.cArgs - i + cNamedArgs - 1;
            VariantInit(&op.dp.rgvarg[n]);
            param = rb_ary_entry(paramS, i-cNamedArgs);
            ole_val2variant(param, &op.dp.rgvarg[n]);
        }
    }

    if(cNamedArgs > 0) {
        op.dp.rgdispidNamedArgs = &(pDispID[1]);
    }

    hr = pole->pDispatch->lpVtbl->Invoke(pole->pDispatch, pDispID[0], 
                                         &IID_NULL, lcid, wFlags, &op.dp, 
                                         &result, &excepinfo, &argErr);

    if (FAILED(hr)) {
        /* mega kludge. if a method in WORD is called and we ask
         * for a result when one is not returned then
         * hResult == DISP_E_EXCEPTION. this only happens on
         * functions whose DISPID > 0x8000 */
        if (hr == DISP_E_EXCEPTION && pDispID[0] > 0x8000) {
            memset(&excepinfo, 0, sizeof(EXCEPINFO));
            hr = pole->pDispatch->lpVtbl->Invoke(pole->pDispatch, pDispID[0], 
                                                 &IID_NULL, lcid, wFlags,
                                                 &op.dp, NULL,
                                                 &excepinfo, &argErr);

        }
    }

    /* clear dispatch parameter */
    for(i = 0; i < op.dp.cArgs; i++ ) {
        VariantClear(&op.dp.rgvarg[i]);
    }

    if (FAILED(hr)) {
        error_msg = ole_excepinfo2msg(&excepinfo);
        rb_str_concat(cmd, error_msg);
        ole_raise(hr, rb_eRuntimeError, RSTRING(cmd)->ptr);
    }

    obj = ole_variant2val(&result);
    VariantClear(&result);
    return obj;
}

static VALUE
fole_invoke(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    return ole_invoke(argc, argv, self, DISPATCH_METHOD|DISPATCH_PROPERTYGET);
}

static VALUE
fole_propertyget(self, property)
    VALUE self, property;
{
    return ole_invoke(1, &property, self, DISPATCH_PROPERTYGET);
}

static VALUE
fole_propertyput(self, property, value)
    VALUE self, property, value;
{
    struct oledata *pole;
    unsigned argErr;
    unsigned int index;
    HRESULT hr;
    EXCEPINFO excepinfo;
    DISPID dispID = DISPID_VALUE;
    DISPID dispIDParam = DISPID_PROPERTYPUT;
    USHORT wFlags = DISPATCH_PROPERTYPUT;
    DISPPARAMS dispParams;
    VARIANTARG propertyValue[2];
    OLECHAR* pBuf[1];
    LCID    lcid = LOCALE_SYSTEM_DEFAULT;
    dispParams.rgdispidNamedArgs = &dispIDParam;
    dispParams.rgvarg = propertyValue;
    dispParams.cNamedArgs = 1;
    dispParams.cArgs = 1;

    VariantInit(&propertyValue[0]);
    VariantInit(&propertyValue[1]);
    memset(&excepinfo, 0, sizeof(excepinfo));

    Data_Get_Struct(self, struct oledata, pole);

    /* get ID from property name */
    pBuf[0]  = ole_mb2wc(RSTRING(property)->ptr, -1);
    hr = pole->pDispatch->lpVtbl->GetIDsOfNames(pole->pDispatch, &IID_NULL,
                                                pBuf, 1, lcid, &dispID);
    SysFreeString(pBuf[0]);

    if(FAILED(hr)) {
        dispParams.cArgs = 2;
        V_VT(&propertyValue[1]) = VT_BSTR;
        V_BSTR(&propertyValue[1]) = ole_mb2wc(RSTRING(property)->ptr, -1);
    }
    /* set property value */
    ole_val2variant(value, &propertyValue[0]);
    hr = pole->pDispatch->lpVtbl->Invoke(pole->pDispatch, dispID, &IID_NULL, 
                                         lcid, wFlags, &dispParams,
                                         NULL, &excepinfo, &argErr);

    for(index = 0; index < dispParams.cArgs; ++index)
        VariantClear(&propertyValue[index]);

    return Qnil;
}

static VALUE
fole_each(self)
    VALUE self;
{
    LCID    lcid = LOCALE_SYSTEM_DEFAULT;

    struct oledata *pole;

    unsigned int argErr;
    EXCEPINFO excepinfo;
    DISPPARAMS dispParams;
    VARIANT result, variant;
    HRESULT hr;
    IEnumVARIANT *pEnum = NULL;

    VALUE obj;

    VariantInit(&result);
    dispParams.rgvarg = NULL;
    dispParams.rgdispidNamedArgs = NULL;
    dispParams.cNamedArgs = 0;
    dispParams.cArgs = 0;
    memset(&excepinfo, 0, sizeof(excepinfo));
    
    Data_Get_Struct(self, struct oledata, pole);
    hr = pole->pDispatch->lpVtbl->Invoke(pole->pDispatch, DISPID_NEWENUM,
                                         &IID_NULL, lcid,
                                         DISPATCH_METHOD | DISPATCH_PROPERTYGET,
                                         &dispParams, &result,
                                         &excepinfo, &argErr);

    if (FAILED(hr)) {
        VariantClear(&result);
        ole_raise(hr, rb_eRuntimeError, "Fail to get IEnum Interface");
    }

    if (V_VT(&result) == VT_UNKNOWN)
        hr = V_UNKNOWN(&result)->lpVtbl->QueryInterface(V_UNKNOWN(&result),
                                                        &IID_IEnumVARIANT,
                                                        (void**)&pEnum);
    else if (V_VT(&result) == VT_DISPATCH)
        hr = V_DISPATCH(&result)->lpVtbl->QueryInterface(V_DISPATCH(&result),
                                                         &IID_IEnumVARIANT,
                                                         (void**)&pEnum);
    if (FAILED(hr) || !pEnum) {
        VariantClear(&result);
        ole_raise(hr, rb_eRuntimeError, "Fail to get IEnum Interface");
    }

    VariantInit(&variant);
    while(pEnum->lpVtbl->Next(pEnum, 1, &variant, NULL) == S_OK) {
/*    while(SUCCEEDED(pEnum->lpVtbl->Next(pEnum, 1, &variant, &i))) {*/
        obj = ole_variant2val(&variant);
        rb_yield(obj);
        VariantClear(&variant);
        VariantInit(&variant);
    }
    VariantClear(&result);
    pEnum->lpVtbl->Release(pEnum);
    return Qnil;
}

static VALUE
fole_missing(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    ID id;
    char* mname;
    int n;
    id = rb_to_id(argv[0]);
    mname = rb_id2name(id);
    if(!mname) {
        rb_raise(rb_eRuntimeError, "Fail : Unknown method or property");
    }
    n = strlen(mname);
    if(mname[n-1] == '=') {
        argv[0] = rb_str_new(mname, n-1);
        return fole_propertyput(self, argv[0], argv[1]);
    }
    else {
        argv[0] = rb_str_new2(mname);
        return ole_invoke(argc, argv, self, DISPATCH_METHOD|DISPATCH_PROPERTYGET);
    }
}

static IEventSinkVtbl vtEventSink;
static BOOL g_IsEventSinkVtblInitialized = FALSE;

void EVENTSINK_Destructor(PIEVENTSINKOBJ);

STDMETHODIMP
EVENTSINK_QueryInterface(
    PEVENTSINK pEV,
    REFIID     iid,
    LPVOID*    ppv
    ) {
    if (IsEqualIID(iid, &IID_IUnknown) ||
        IsEqualIID(iid, &IID_IDispatch) ||
        IsEqualIID(iid, &((PIEVENTSINKOBJ)pEV)->m_iid)) {
        *ppv = pEV;
    }
    else {
        *ppv = NULL;
        return E_NOINTERFACE;
    }
    ((LPUNKNOWN)*ppv)->lpVtbl->AddRef((LPUNKNOWN)*ppv);
    return NOERROR;
}

STDMETHODIMP_(ULONG)
EVENTSINK_AddRef(
    PEVENTSINK pEV
    ){
    PIEVENTSINKOBJ pEVObj = (PIEVENTSINKOBJ)pEV;
    return ++pEVObj->m_cRef;
}

STDMETHODIMP_(ULONG) EVENTSINK_Release(
    PEVENTSINK pEV
    ) {
    PIEVENTSINKOBJ pEVObj = (PIEVENTSINKOBJ)pEV;
    --pEVObj->m_cRef;
    if(pEVObj->m_cRef != 0)
        return pEVObj->m_cRef;
    EVENTSINK_Destructor(pEVObj);
    return 0;
}

STDMETHODIMP EVENTSINK_GetTypeInfoCount(
    PEVENTSINK pEV,
    UINT *pct
    ) {
    *pct = 0;
    return NOERROR;
}

STDMETHODIMP EVENTSINK_GetTypeInfo(
    PEVENTSINK pEV,
    UINT info,
    LCID lcid,
    ITypeInfo **pInfo
    ) {
    *pInfo = NULL;
    return DISP_E_BADINDEX;
}

STDMETHODIMP EVENTSINK_GetIDsOfNames(
    PEVENTSINK pEV,
    REFIID riid,
    OLECHAR **szNames,
    UINT cNames,
    LCID lcid,
    DISPID *pDispID
    ) {
    return DISP_E_UNKNOWNNAME;
}

static VALUE
ole_search_event(ary, pev, is_default)
    VALUE ary;
    char *pev;
    BOOL  *is_default;
{
    VALUE event;
    VALUE def_event;
    VALUE event_name;
    int i, len;

    *is_default = FALSE;
    def_event = Qnil;
    len = RARRAY(ary)->len;
    for(i = 0; i < len; i++) {
        event = rb_ary_entry(ary, i);
        event_name = rb_ary_entry(event, 1);
        if(NIL_P(event_name)) {
            *is_default = TRUE;
            def_event = event;
        }
        else if (strcmp(pev, STR2CSTR(event_name)) == 0) {
            *is_default = FALSE;
            return event;
        }
    }
    return def_event;
}

STDMETHODIMP EVENTSINK_Invoke(
    PEVENTSINK pEventSink,
    DISPID dispid,
    REFIID riid,
    LCID lcid,
    WORD wFlags,
    DISPPARAMS *pdispparams,
    VARIANT *pvarResult,
    EXCEPINFO *pexcepinfo,
    UINT *puArgErr
    ) {

    HRESULT hr;
    BSTR bstr;
    unsigned int count;
    unsigned int i;
    ITypeInfo *pTypeInfo;
    char *pev;
    VALUE ary, obj, event, handler, args;
    BOOL is_default_handler;

    PIEVENTSINKOBJ pEV = (PIEVENTSINKOBJ)pEventSink;
    pTypeInfo = pEV->pTypeInfo;

    obj = rb_ary_entry(ary_ole_event, pEV->m_event_id);
    if (!rb_obj_is_kind_of(obj, cWIN32OLE_EVENT)) {
        return NOERROR;
    }

    ary = rb_ivar_get(obj, id_events);
    if (NIL_P(ary) || TYPE(ary) != T_ARRAY) {
        return NOERROR;
    }
    hr = pTypeInfo->lpVtbl->GetNames(pTypeInfo, dispid,
                                     &bstr, 1, &count);
    if (FAILED(hr)) {
        return NOERROR;
    }
    pev = ole_wc2mb(bstr);
    SysFreeString(bstr);
    event = ole_search_event(ary, pev, &is_default_handler);
    if (NIL_P(event)) {
        free(pev);
        return NOERROR;
    }
    args = rb_ary_new();
    if (is_default_handler) {
        rb_ary_push(args, rb_str_new2(pev));
    }

    // make argument of event handler
    for (i = 0; i < pdispparams->cArgs; ++i) {
        VARIANT *pVariant = &pdispparams->rgvarg[pdispparams->cArgs-i-1];
        rb_ary_push(args, ole_variant2val(pVariant));
    }

    handler = rb_ary_entry(event, 0);

    rb_apply(handler, rb_intern("call"), args);

    return NOERROR;
}

PIEVENTSINKOBJ
EVENTSINK_Constructor() {
    PIEVENTSINKOBJ pEv;
    if (!g_IsEventSinkVtblInitialized) {
        vtEventSink.QueryInterface=EVENTSINK_QueryInterface;
        vtEventSink.AddRef = EVENTSINK_AddRef;
        vtEventSink.Release = EVENTSINK_Release;
        vtEventSink.Invoke = EVENTSINK_Invoke;
        vtEventSink.GetIDsOfNames = EVENTSINK_GetIDsOfNames;
        vtEventSink.GetTypeInfoCount = EVENTSINK_GetTypeInfoCount;
        vtEventSink.GetTypeInfo = EVENTSINK_GetTypeInfo;

        g_IsEventSinkVtblInitialized = TRUE;
    }
    pEv = (PIEVENTSINKOBJ)malloc(sizeof(IEVENTSINKOBJ));
    if(pEv == NULL) return NULL;
    pEv->lpVtbl = &vtEventSink;
    pEv->m_cRef = 0;
    return pEv;
}

void EVENTSINK_Destructor(
    PIEVENTSINKOBJ pEVObj
    ) {
    if(pEVObj != NULL) {
        free(pEVObj);
    }
}

static HRESULT
find_iid(ole, pitf, piid, ppTypeInfo)
    VALUE ole;
    char *pitf;
    IID *piid;
    ITypeInfo **ppTypeInfo;
{
    HRESULT hr;
    IDispatch *pDispatch;
    ITypeInfo *pTypeInfo;
    ITypeLib *pTypeLib;
    TYPEATTR *pTypeAttr;
    HREFTYPE RefType;
    ITypeInfo *pImplTypeInfo;
    TYPEATTR *pImplTypeAttr;

    struct oledata *pole;
    unsigned int index;
    unsigned int count;
    unsigned int type;
    BSTR bstr;
    char *pstr;

    BOOL is_found = FALSE;
    LCID    lcid = LOCALE_SYSTEM_DEFAULT;

    Data_Get_Struct(ole, struct oledata, pole);

    pDispatch = pole->pDispatch;

    hr = pDispatch->lpVtbl->GetTypeInfo(pDispatch, 0, lcid, &pTypeInfo);
    if (FAILED(hr))
        return hr;

    hr = pTypeInfo->lpVtbl->GetContainingTypeLib(pTypeInfo,
                                                 &pTypeLib,
                                                 &index);
    pTypeInfo->lpVtbl->Release(pTypeInfo);
    if (FAILED(hr))
        return hr;

    if (!pitf) {
        hr = pTypeLib->lpVtbl->GetTypeInfoOfGuid(pTypeLib,
                                                 piid,
                                                 ppTypeInfo);
        pTypeLib->lpVtbl->Release(pTypeLib);
        return hr;
    }
    count = pTypeLib->lpVtbl->GetTypeInfoCount(pTypeLib);
    for (index = 0; index < count; index++) {
        hr = pTypeLib->lpVtbl->GetTypeInfo(pTypeLib,
                                           index,
                                           &pTypeInfo);
        if (FAILED(hr))
            break;
        hr = pTypeInfo->lpVtbl->GetTypeAttr(pTypeInfo,
                                            &pTypeAttr);

        if(FAILED(hr)) {
            pTypeInfo->lpVtbl->Release(pTypeInfo);
            break;
        }
        if(pTypeAttr->typekind == TKIND_COCLASS) {
            for (type = 0; type < pTypeAttr->cImplTypes; type++) {
                hr = pTypeInfo->lpVtbl->GetRefTypeOfImplType(pTypeInfo,
                                                             type,
                                                             &RefType);
                if (FAILED(hr))
                    break;
		hr = pTypeInfo->lpVtbl->GetRefTypeInfo(pTypeInfo,
                                                       RefType,
                                                       &pImplTypeInfo);
		if (FAILED(hr))
		    break;

		hr = pImplTypeInfo->lpVtbl->GetDocumentation(pImplTypeInfo,
                                                             -1,
                                                             &bstr,
                                                             NULL, NULL, NULL);
		if (FAILED(hr)) {
		    pImplTypeInfo->lpVtbl->Release(pImplTypeInfo);
		    break;
		}
                pstr = ole_wc2mb(bstr);
		if (strcmp(pitf, pstr) == 0) {
		    hr = pImplTypeInfo->lpVtbl->GetTypeAttr(pImplTypeInfo,
                                                            &pImplTypeAttr);
		    if (SUCCEEDED(hr)) {
			is_found = TRUE;
			*piid = pImplTypeAttr->guid;
			if (ppTypeInfo) {
			    *ppTypeInfo = pImplTypeInfo;
			    (*ppTypeInfo)->lpVtbl->AddRef((*ppTypeInfo));
			}
			pImplTypeInfo->lpVtbl->ReleaseTypeAttr(pImplTypeInfo,
                                                               pImplTypeAttr);
		    }
		}
                free(pstr);
		pImplTypeInfo->lpVtbl->Release(pImplTypeInfo);
		if (is_found || FAILED(hr))
		    break;
	    }
	}

	pTypeInfo->lpVtbl->ReleaseTypeAttr(pTypeInfo, pTypeAttr);
	pTypeInfo->lpVtbl->Release(pTypeInfo);
	if (is_found || FAILED(hr))
	    break;
    }
    pTypeLib->lpVtbl->Release(pTypeLib);
    if(!is_found)
        return E_NOINTERFACE;
    return hr;
}

static HRESULT
find_default_source(ole, piid, ppTypeInfo)
    VALUE ole;
    IID *piid;
    ITypeInfo **ppTypeInfo;
{
    HRESULT hr;
    IProvideClassInfo2 *pProvideClassInfo2;
    IProvideClassInfo *pProvideClassInfo;

    IDispatch *pDispatch;
    ITypeInfo *pTypeInfo;
    TYPEATTR *pTypeAttr;
    unsigned int i;
    int iFlags;
    HREFTYPE hRefType;

    struct oledata *pole;

    Data_Get_Struct(ole, struct oledata, pole);
    pDispatch = pole->pDispatch;
    hr = pDispatch->lpVtbl->QueryInterface(pDispatch,
                                           &IID_IProvideClassInfo2,
                                           (void**)&pProvideClassInfo2);
    if (SUCCEEDED(hr)) {
	hr = pProvideClassInfo2->lpVtbl->GetGUID(pProvideClassInfo2,
                                                 GUIDKIND_DEFAULT_SOURCE_DISP_IID,
                                                 piid);
	pProvideClassInfo2->lpVtbl->Release(pProvideClassInfo2);
	return find_iid(ole, NULL, piid, ppTypeInfo);
    }
    hr = pDispatch->lpVtbl->QueryInterface(pDispatch,
                                           &IID_IProvideClassInfo,
                                           (void**)&pProvideClassInfo);
    if (FAILED(hr))
	return hr;

    hr = pProvideClassInfo->lpVtbl->GetClassInfo(pProvideClassInfo,
                                                 &pTypeInfo);
    pProvideClassInfo->lpVtbl->Release(pProvideClassInfo);
    if (FAILED(hr))
	return hr;

    hr = pTypeInfo->lpVtbl->GetTypeAttr(pTypeInfo, &pTypeAttr);
    if (FAILED(hr)) {
	pTypeInfo->lpVtbl->Release(pTypeInfo);
	return hr;
    }
    // Enumerate all implemented types of the COCLASS
    for (i = 0; i < pTypeAttr->cImplTypes; i++) {
	hr = pTypeInfo->lpVtbl->GetImplTypeFlags(pTypeInfo, i, &iFlags);
	if (FAILED(hr))
	    continue;

        // looking for the [default] [source]
	// we just hope that it is a dispinterface :-)
	if ((iFlags & IMPLTYPEFLAG_FDEFAULT) &&
	    (iFlags & IMPLTYPEFLAG_FSOURCE)) {

	    hr = pTypeInfo->lpVtbl->GetRefTypeOfImplType(pTypeInfo,
                                                         i, &hRefType);
	    if (FAILED(hr))
		continue;
	    hr = pTypeInfo->lpVtbl->GetRefTypeInfo(pTypeInfo,
                                                   hRefType, ppTypeInfo);
	    if (SUCCEEDED(hr))
		break;
	}
    }

    pTypeInfo->lpVtbl->ReleaseTypeAttr(pTypeInfo, pTypeAttr);
    pTypeInfo->lpVtbl->Release(pTypeInfo);

    // Now that would be a bad surprise, if we didn't find it, wouldn't it?
    if (!*ppTypeInfo) {
	if (SUCCEEDED(hr))
	    hr = E_UNEXPECTED;
	return hr;
    }

    // Determine IID of default source interface
    hr = (*ppTypeInfo)->lpVtbl->GetTypeAttr(*ppTypeInfo, &pTypeAttr);
    if (SUCCEEDED(hr)) {
	*piid = pTypeAttr->guid;
	(*ppTypeInfo)->lpVtbl->ReleaseTypeAttr(*ppTypeInfo, pTypeAttr);
    }
    else
	(*ppTypeInfo)->lpVtbl->Release(*ppTypeInfo);

    return hr;

}

static void
ole_event_free(poleev)
    struct oleeventdata *poleev;
{
    ULONG n;
    ITypeInfo *pTI = poleev->pEvent->pTypeInfo;
    IConnectionPoint *pCP = poleev->pEvent->pConnectionPoint;
    pCP->lpVtbl->Unadvise(pCP, poleev->pEvent->m_dwCookie);
    n = pCP->lpVtbl->Release(pCP);
    n = pTI->lpVtbl->Release(pTI);
    ole_msg_loop();
    CoFreeUnusedLibraries();
}

static VALUE
fev_s_new(argc, argv, klass)
    int argc;
    VALUE *argv;
    VALUE klass;
{
    VALUE ole, itf;
    VALUE obj;
    struct oledata *pole;
    char *pitf;
    HRESULT hr;
    IID iid;
    ITypeInfo *pTypeInfo;
    IDispatch *pDispatch;
    IConnectionPointContainer *pContainer;
    IConnectionPoint *pConnectionPoint;
    IEVENTSINKOBJ *pIEV;
    DWORD dwCookie;
    struct oleeventdata *poleev;

    rb_scan_args(argc, argv, "11", &ole, &itf);
    if (!rb_obj_is_kind_of(ole, cWIN32OLE)) {
        rb_raise(rb_eTypeError, "1st parametor must be WIN32OLE object.");
    }

    if(TYPE(itf) != T_NIL) {
        Check_SafeStr(itf);
        pitf = STR2CSTR(itf);
        hr = find_iid(ole, pitf, &iid, &pTypeInfo);
    }
    else {
        hr = find_default_source(ole, &iid, &pTypeInfo);
    }
    if (FAILED(hr)) {
        ole_raise(hr, rb_eRuntimeError, "not found interface");
    }

    Data_Get_Struct(ole, struct oledata, pole);
    pDispatch = pole->pDispatch;
    hr = pDispatch->lpVtbl->QueryInterface(pDispatch,
                                           &IID_IConnectionPointContainer,
                                           (void**)&pContainer);
    if (FAILED(hr)) {
        pTypeInfo->lpVtbl->Release(pTypeInfo);
        ole_raise(hr, rb_eRuntimeError,
                  "fail to query IConnectionPointContainer");
    }

    hr = pContainer->lpVtbl->FindConnectionPoint(pContainer,
                                                 &iid,
                                                 &pConnectionPoint);
    pContainer->lpVtbl->Release(pContainer);
    if (FAILED(hr)) {
        pTypeInfo->lpVtbl->Release(pTypeInfo);
        ole_raise(hr, rb_eRuntimeError, "fail to query IConnectionPoint");
    }
    pIEV = EVENTSINK_Constructor();
    hr = pConnectionPoint->lpVtbl->Advise(pConnectionPoint,
                                          (IUnknown*)pIEV,
                                          &dwCookie);
    if (FAILED(hr)) {
        ole_raise(hr, rb_eRuntimeError, "Advise Error");
    }

    /*
    pConnectionPoint->lpVtbl->AddRef(pConnectionPoint);
     */
    // create WIN32OLE_EVENT object
    obj = Data_Make_Struct(klass,struct oleeventdata,0,ole_event_free,poleev);
    poleev->pEvent = pIEV;
    poleev->pEvent->m_event_id
        = NUM2INT(rb_funcall(ary_ole_event, rb_intern("length"), 0));
    poleev->pEvent->pConnectionPoint = pConnectionPoint;
    poleev->pEvent->pTypeInfo = pTypeInfo;
    poleev->pEvent->m_iid = iid;
    poleev->pEvent->m_dwCookie = dwCookie;

    rb_ary_push(ary_ole_event, obj);
    return obj;
}

static VALUE
fev_s_msg_loop(klass)
    VALUE klass;
{
    ole_msg_loop();
    return Qnil;
}


static void
add_event_call_back(obj, data)
    VALUE obj;
    VALUE data;
{
    VALUE ary = rb_ivar_get(obj, id_events);
    if (NIL_P(ary) || TYPE(ary) != T_ARRAY) {
        ary = rb_ary_new();
        rb_ivar_set(obj, id_events, ary);
    }
    rb_ary_push(ary, data);
}

static VALUE
fev_on_event(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE event, args, data;
    rb_scan_args(argc, argv, "01*", &event, &args);
    if(!NIL_P(event)) {
        Check_SafeStr(event);
    }
    data = rb_ary_new3(3, rb_f_lambda(), event, args);
    add_event_call_back(self, data);
    return Qnil;
}

void
Init_win32ole()
{
    ary_ole_event = rb_ary_new();
    rb_global_variable(&ary_ole_event);
    id_events = rb_intern("events");

    cWIN32OLE = rb_define_class("WIN32OLE", rb_cObject);

    rb_define_singleton_method(cWIN32OLE, "new", fole_s_new, 1);
    rb_define_singleton_method(cWIN32OLE, "connect", fole_s_connect, 1);
    rb_define_singleton_method(cWIN32OLE, "const_load", fole_s_const_load, -1);

    rb_define_method(cWIN32OLE, "invoke", fole_invoke, -1);
    rb_define_method(cWIN32OLE, "[]", fole_propertyget, 1);
    rb_define_method(cWIN32OLE, "[]=", fole_propertyput, 2);
    rb_define_method(cWIN32OLE, "each", fole_each, 0);
    rb_define_method(cWIN32OLE, "method_missing", fole_missing, -1);

    rb_define_const(cWIN32OLE, "VERSION", rb_str_new2(WIN32OLE_VERSION));

    cWIN32OLE_EVENT = rb_define_class("WIN32OLE_EVENT", rb_cObject);

    rb_define_singleton_method(cWIN32OLE_EVENT, "new", fev_s_new, -1);
    rb_define_singleton_method(cWIN32OLE_EVENT, "message_loop", fev_s_msg_loop, 0);

    rb_define_method(cWIN32OLE_EVENT, "on_event", fev_on_event, -1);
}
