/* TXT2COM.CPP -> TXT2COM.EXE

   Dieses Programm erzeugt aus einem Text, ein
   ausfhrbares Programm, welches den Text anzeigt.
   Dazu wird das Programm SHOW2COM.ASM bentigt,
   das in dieses Programm eingebunden wird.


   Copyright (c) 1997 by Little-Coders (Michael Neumann)
   email: neumann@s-direktnet.de
*/

#include <stdio.h>
#include <iostream.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

#define BYTE unsigned char
#define COPYRIGHT_MELDUNG cout << "Copyright (c) 1997 by Little-Coders (Michael Neumann)" << endl


long flen;

FILE *srcfile, *destfile;
#define Show2Com_Size 1138
#define MAXFILESIZE (65530-Show2Com_Size-0x100)
unsigned char Show2Com[Show2Com_Size] =
{
   0xE9, 0x57, 0x02, 0x00, 0x00, 0x00, 0x20, 0x54, 0x61, 0x73, 0x74, 0x65,
   0x6E, 0x3A, 0x20, 0x46, 0x31, 0x20, 0x3D, 0x20, 0x48, 0x69, 0x6C, 0x66,
   0x65, 0x20, 0xB3, 0x20, 0x43, 0x75, 0x72, 0x73, 0x6F, 0x72, 0x74, 0x61,
   0x73, 0x74, 0x65, 0x6E, 0x20, 0xB3, 0x20, 0x18, 0x19, 0x20, 0xB3, 0x20,
   0x4D, 0x61, 0x75, 0x73, 0x20, 0xB3, 0x20, 0x45, 0x53, 0x43, 0x20, 0xB3,
   0x20, 0x28, 0x63, 0x29, 0x31, 0x39, 0x39, 0x37, 0x20, 0x62, 0x79, 0x20,
   0x4D, 0x69, 0x63, 0x68, 0x2E, 0x20, 0x4E, 0x65, 0x75, 0x6D, 0x61, 0x6E,
   0x6E, 0x20, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC9, 0xCD,
   0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
   0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
   0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xBB, 0xBA, 0x20,
   0x43, 0x75, 0x72, 0x73, 0x6F, 0x72, 0x2D, 0x54, 0x61, 0x73, 0x74, 0x65,
   0x6E, 0x3A, 0x20, 0x5A, 0x65, 0x69, 0x6C, 0x65, 0x20, 0x68, 0x6F, 0x63,
   0x68, 0x2F, 0x72, 0x75, 0x6E, 0x74, 0x65, 0x72, 0x20, 0xBA, 0xBA, 0x20,
   0x42, 0x69, 0x6C, 0x64, 0x2D, 0x54, 0x61, 0x73, 0x74, 0x65, 0x6E, 0x3A,
   0x20, 0x20, 0x20, 0x53, 0x65, 0x69, 0x74, 0x65, 0x20, 0x68, 0x6F, 0x63,
   0x68, 0x2F, 0x72, 0x75, 0x6E, 0x74, 0x65, 0x72, 0x20, 0xBA, 0xBA, 0x20,
   0x4D, 0x61, 0x75, 0x73, 0x3A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x5A, 0x65, 0x69, 0x6C, 0x65, 0x20, 0x68, 0x6F, 0x63,
   0x68, 0x2F, 0x72, 0x75, 0x6E, 0x74, 0x65, 0x72, 0x20, 0xBA, 0xBA, 0x20,
   0x4D, 0x61, 0x75, 0x73, 0x74, 0x61, 0x73, 0x74, 0x65, 0x6E, 0x3A, 0x20,
   0x20, 0x20, 0x20, 0x73, 0x63, 0x68, 0x6E, 0x65, 0x6C, 0x6C, 0x20, 0x73,
   0x63, 0x72, 0x6F, 0x6C, 0x6C, 0x65, 0x6E, 0x20, 0x20, 0xBA, 0xBA, 0x20,
   0x48, 0x6F, 0x6D, 0x65, 0x2C, 0x45, 0x6E, 0x64, 0x3A, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x44, 0x61, 0x74, 0x65, 0x69, 0x2D, 0x41, 0x6E, 0x66,
   0x61, 0x6E, 0x67, 0x2F, 0x45, 0x6E, 0x64, 0x65, 0x20, 0xBA, 0xBA, 0x20,
   0x45, 0x53, 0x43, 0x3A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x45, 0x6E, 0x64, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xBA, 0xC8, 0xCD,
   0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
   0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD,
   0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xCD, 0xBC, 0xBF, 0x00,
   0xBC, 0x8E, 0xC7, 0x33, 0xFF, 0xB9, 0x80, 0x07, 0xF3, 0xAB, 0xB9, 0x50,
   0x00, 0xB4, 0x30, 0xF3, 0xAB, 0xC3, 0x8B, 0xC3, 0xB0, 0x0C, 0xBA, 0xD4,
   0x03, 0xEF, 0x8B, 0xC3, 0x25, 0xFF, 0x00, 0x8A, 0xE0, 0xB0, 0x0D, 0xEF,
   0xC3, 0xB3, 0xA0, 0xF6, 0xE3, 0x8B, 0xF8, 0xB8, 0x00, 0xBC, 0x8E, 0xC0,
   0xB9, 0x50, 0x00, 0x2E, 0x8A, 0x04, 0x3C, 0x0D, 0x74, 0x0A, 0x3C, 0x09,
   0x75, 0x02, 0xB0, 0x20, 0x46, 0xEB, 0x03, 0x90, 0xB0, 0x20, 0x26, 0x88,
   0x05, 0x83, 0xC7, 0x02, 0x49, 0x75, 0xE4, 0xC3, 0xBA, 0xDA, 0x03, 0xEC,
   0xA8, 0x08, 0x75, 0xFB, 0xEC, 0xA8, 0x08, 0x74, 0xFB, 0xB8, 0x20, 0x1E,
   0xE8, 0x9B, 0xFF, 0xC6, 0x06, 0x05, 0x01, 0x00, 0xBE, 0x72, 0x05, 0x03,
   0x36, 0x59, 0x01, 0xA1, 0x59, 0x01, 0xA3, 0x5B, 0x01, 0xA1, 0x03, 0x01,
   0x39, 0x06, 0x5B, 0x01, 0x73, 0x1E, 0xA0, 0x05, 0x01, 0xE8, 0xA1, 0xFF,
   0x83, 0xC6, 0x02, 0x89, 0x36, 0x5B, 0x01, 0x81, 0x2E, 0x5B, 0x01, 0x72,
   0x05, 0xFE, 0x06, 0x05, 0x01, 0x80, 0x3E, 0x05, 0x01, 0x18, 0x72, 0xD9,
   0xBE, 0x06, 0x01, 0xB0, 0x18, 0xE8, 0x81, 0xFF, 0xC3, 0xA1, 0x03, 0x01,
   0x39, 0x06, 0x59, 0x01, 0x73, 0x28, 0x8B, 0x36, 0x59, 0x01, 0x81, 0xC6,
   0x72, 0x05, 0xBB, 0x18, 0x00, 0xB8, 0x72, 0x05, 0x03, 0x06, 0x03, 0x01,
   0x3B, 0xF0, 0x73, 0x12, 0x2E, 0x80, 0x3C, 0x0D, 0x74, 0x03, 0x46, 0xEB,
   0xEC, 0x83, 0xC6, 0x02, 0x4B, 0x75, 0xE6, 0x33, 0xC0, 0xC3, 0xB8, 0xFF,
   0xFF, 0xC3, 0x8C, 0xC8, 0x8E, 0xD8, 0x8E, 0xD0, 0xBC, 0xFE, 0x00, 0xBB,
   0x00, 0x20, 0xE8, 0x29, 0xFF, 0xB4, 0x03, 0x32, 0xFF, 0xCD, 0x10, 0x89,
   0x0E, 0x57, 0x01, 0xB4, 0x01, 0xB9, 0x00, 0x01, 0xCD, 0x10, 0xB8, 0x01,
   0x10, 0xB7, 0x01, 0xCD, 0x10, 0x33, 0xC0, 0xCD, 0x33, 0x3D, 0xFF, 0xFF,
   0x75, 0x05, 0xC6, 0x06, 0x5D, 0x01, 0x01, 0xE8, 0x3E, 0xFF, 0xB4, 0x01,
   0xCD, 0x16, 0x75, 0x31, 0x80, 0x3E, 0x5D, 0x01, 0x01, 0x75, 0xF3, 0xB8,
   0x03, 0x00, 0xCD, 0x33, 0x83, 0xFB, 0x01, 0x75, 0x03, 0xE9, 0x10, 0x01,
   0x83, 0xFB, 0x02, 0x75, 0x05, 0x33, 0xFF, 0xE9, 0xC7, 0x00, 0xB8, 0x0B,
   0x00, 0xCD, 0x33, 0x0B, 0xD2, 0x78, 0x07, 0x74, 0xD1, 0x79, 0x00, 0xE9,
   0x72, 0x01, 0xE9, 0x34, 0x01, 0x32, 0xE4, 0xCD, 0x16, 0x0A, 0xC0, 0x74,
   0x07, 0x3C, 0x1B, 0x75, 0xBD, 0xEB, 0x7F, 0x90, 0x80, 0xFC, 0x50, 0x75,
   0x03, 0xE9, 0x58, 0x01, 0x80, 0xFC, 0x48, 0x75, 0x03, 0xE9, 0x15, 0x01,
   0x80, 0xFC, 0x49, 0x75, 0x03, 0xE9, 0xCC, 0x00, 0x80, 0xFC, 0x51, 0x75,
   0x05, 0x33, 0xFF, 0xE9, 0x83, 0x00, 0x80, 0xFC, 0x47, 0x75, 0x12, 0x83,
   0x3E, 0x59, 0x01, 0x00, 0x75, 0x02, 0xEB, 0x8A, 0xC7, 0x06, 0x59, 0x01,
   0x00, 0x00, 0xE9, 0x7E, 0xFF, 0x80, 0xFC, 0x4F, 0x75, 0x06, 0xBF, 0x01,
   0x00, 0xEB, 0x62, 0x90, 0x80, 0xFC, 0x3B, 0x74, 0x03, 0xE9, 0x6E, 0xFF,
   0xBE, 0x5E, 0x01, 0xBF, 0x00, 0xBC, 0x8E, 0xC7, 0xBF, 0x2C, 0x05, 0xB4,
   0x30, 0xB1, 0x08, 0xB5, 0x24, 0x2E, 0x8A, 0x04, 0x46, 0x26, 0x89, 0x05,
   0x83, 0xC7, 0x02, 0xFE, 0xCD, 0x75, 0xF2, 0x83, 0xC7, 0x58, 0xFE, 0xC9,
   0x75, 0xE9, 0x33, 0xC0, 0xCD, 0x16, 0xB8, 0x0B, 0x00, 0xCD, 0x33, 0xE9,
   0x39, 0xFF, 0xBB, 0x00, 0x00, 0xE8, 0x36, 0xFE, 0xB8, 0x01, 0x10, 0xB7,
   0x00, 0xCD, 0x10, 0xB4, 0x01, 0x8B, 0x0E, 0x57, 0x01, 0xCD, 0x10, 0xB8,
   0x20, 0x0F, 0xBF, 0x00, 0xBC, 0x8E, 0xC7, 0x33, 0xFF, 0xB9, 0xD0, 0x07,
   0xF3, 0xAB, 0xE9, 0xF0, 0x00, 0xB9, 0x18, 0x00, 0xE8, 0xA2, 0xFE, 0x0B,
   0xC0, 0x74, 0x03, 0xE9, 0x05, 0xFF, 0xA1, 0x03, 0x01, 0x39, 0x06, 0x59,
   0x01, 0x72, 0x03, 0xE9, 0xF9, 0xFE, 0x8B, 0x36, 0x59, 0x01, 0x81, 0xC6,
   0x72, 0x05, 0x2E, 0x80, 0x3C, 0x0D, 0x74, 0x03, 0x46, 0xEB, 0xF7, 0x83,
   0xC6, 0x02, 0x81, 0xEE, 0x72, 0x05, 0x89, 0x36, 0x59, 0x01, 0x0B, 0xFF,
   0x75, 0xCA, 0x49, 0x75, 0xC7, 0xE9, 0xD3, 0xFE, 0x83, 0x3E, 0x59, 0x01,
   0x00, 0x75, 0x03, 0xE9, 0xCC, 0xFE, 0xBB, 0x18, 0x00, 0x8B, 0x36, 0x59,
   0x01, 0x81, 0xC6, 0x72, 0x05, 0x83, 0xEE, 0x03, 0x81, 0xFE, 0x72, 0x05,
   0x73, 0x09, 0xC7, 0x06, 0x59, 0x01, 0x00, 0x00, 0xE9, 0xAC, 0xFE, 0x2E,
   0x80, 0x3C, 0x0D, 0x74, 0x03, 0x4E, 0xEB, 0xE8, 0x83, 0xC6, 0x02, 0x81,
   0xEE, 0x72, 0x05, 0x89, 0x36, 0x59, 0x01, 0x4B, 0x75, 0xCF, 0xE9, 0x92,
   0xFE, 0x83, 0x3E, 0x59, 0x01, 0x00, 0x75, 0x03, 0xE9, 0x8B, 0xFE, 0x8B,
   0x36, 0x59, 0x01, 0x81, 0xC6, 0x72, 0x05, 0x83, 0xEE, 0x03, 0x81, 0xFE,
   0x72, 0x05, 0x73, 0x09, 0xC7, 0x06, 0x59, 0x01, 0x00, 0x00, 0xE9, 0x6E,
   0xFE, 0x2E, 0x80, 0x3C, 0x0D, 0x74, 0x03, 0x4E, 0xEB, 0xE8, 0x83, 0xC6,
   0x02, 0x81, 0xEE, 0x72, 0x05, 0x89, 0x36, 0x59, 0x01, 0xE9, 0x57, 0xFE,
   0xE8, 0xEA, 0xFD, 0x0B, 0xC0, 0x74, 0x03, 0xE9, 0x50, 0xFE, 0xA1, 0x03,
   0x01, 0x39, 0x06, 0x59, 0x01, 0x72, 0x03, 0xE9, 0x44, 0xFE, 0x8B, 0x36,
   0x59, 0x01, 0x81, 0xC6, 0x72, 0x05, 0x2E, 0x80, 0x3C, 0x0D, 0x74, 0x03,
   0x46, 0xEB, 0xF7, 0x83, 0xC6, 0x02, 0x81, 0xEE, 0x72, 0x05, 0x89, 0x36,
   0x59, 0x01, 0xE9, 0x22, 0xFE, 0xB8, 0x00, 0x4C, 0xCD, 0x21
};


void main( int nargs, char *argc[] )
{
   COPYRIGHT_MELDUNG;
   if( nargs != 3 )
   {
	  cout << "USES: TXT2COM textfile comfile" << endl;
	  return;
   }

   srcfile = fopen( argc[1], "rb" );
   if( srcfile == NULL )
   {
	  cout << "Error while opening textfile <" << argc[1] << ">." << endl;
	  return;
   }

   flen = filelength( fileno( srcfile ) );
   if( flen <= 0 || flen >=MAXFILESIZE)
   {
	  cout << "Textfile has illegal size." << endl;
	  fclose( srcfile );
	  return;
   }

   destfile = fopen( argc[2],"w+b");
   if( destfile == NULL )
   {
	  cout << "Error while opening or creating comfile <" << argc[2] << ">." << endl;
	  fclose( srcfile );
	  return;
   }
   unsigned short fl = flen;
   Show2Com[3] = (BYTE) (fl&0xFF);
   Show2Com[4] = (BYTE) (fl>>8);

   fwrite(Show2Com,1,Show2Com_Size,destfile);
   for(int i=0;i<flen;i++)
   {
	fputc(fgetc(srcfile),destfile);
   }
   fputc( 13, destfile);
   fputc( 10, destfile);
   fclose( destfile );
   fclose( srcfile );

   cout << "Ready!!!" << endl;
}
